﻿namespace St0rm.MapDownloader
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using Microsoft.Win32;

    public class Config
    {
        #region Singleton
        /// <summary>
        /// Represents a singleton instance of the Config class
        /// </summary>
        public static Config Instance = new Config();
        #endregion

        #region Constructors
        static Config()
        {
            Load();
        }
        #endregion

        #region Properties

        private String _installDir = null;
        /// <summary>
        /// Gets or Sets the current Install Directory of Renegade
        /// </summary>
        public static String InstallDirectory
        {
            get
            {
                return Instance._installDir;
            }
            set
            {
                Instance._installDir = value;
            }
        }

        #endregion

        #region Methods
        /// <summary>
        /// Loads settings from the registry pertaining to the 
        /// </summary>
        public static void Load()
        {
            RegistryKey renKey = Registry.LocalMachine.OpenSubKey(@"SOFTWARE\Westwood\Renegade");
            if (renKey == null)
            {
                RegistryKey renKey2 = Registry.LocalMachine.OpenSubKey(@"SOFTWARE\Wow6432Node\Westwood\Renegade");
                if (renKey2 == null)
                {
                    System.Windows.Forms.MessageBox.Show("Renegade installation not found, C:\\ will be used as the default install directory");
                    Instance._installDir = @"C:\";
                }
                else
                {
                    Instance._installDir = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(renKey2.GetValue("InstallPath").ToString()), "data");
                    renKey2.Close();
                }
            }
            else
            {
                Instance._installDir = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(renKey.GetValue("InstallPath").ToString()), "data");
                renKey.Close();
            }
        }

        #endregion
    }
}
